package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstancePortStatesResponse(
    portStates: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.InstancePortState]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse = {
    import GetInstancePortStatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
      .builder()
      .optionallyWith(
        portStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portStates)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse
      .wrap(buildAwsValue())
}
object GetInstancePortStatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse(
        portStatesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def portStatesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstancePortState.ReadOnly]
    ]
    def portStates: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.InstancePortState.ReadOnly
    ]] = AwsError.unwrapOptionField("portStates", portStatesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly {
    override def portStatesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstancePortState.ReadOnly]
    ] = scala
      .Option(impl.portStates())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstancePortState.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstancePortStatesResponse.ReadOnly =
    new Wrapper(impl)
}
