package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceAccessDetailsResponse(
    accessDetails: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse = {
    import GetInstanceAccessDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
      .builder()
      .optionallyWith(accessDetails.map(value => value.buildAwsValue()))(
        _.accessDetails
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse
      .wrap(buildAwsValue())
}
object GetInstanceAccessDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse(
        accessDetailsValue.map(value => value.editable)
      )
    def accessDetailsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly
    ]
    def accessDetails: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly
    ] = AwsError.unwrapOptionField("accessDetails", accessDetailsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly {
    override def accessDetailsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.ReadOnly
    ] = scala
      .Option(impl.accessDetails())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceAccessDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceAccessDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
