package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDomainsResponse(
    domains: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Domain]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainsResponse = {
    import GetDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
      .builder()
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domains)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse
      .wrap(buildAwsValue())
}
object GetDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse(
        domainsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def domainsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def domains: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly
    ]] = AwsError.unwrapOptionField("domains", domainsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly {
    override def domainsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Domain.ReadOnly]] =
      scala
        .Option(impl.domains())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Domain.wrap(item)
          }.toList
        )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
