package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionsRequest(
    distributionName: Option[ResourceName] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest = {
    import GetDistributionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
      .builder()
      .optionallyWith(distributionName.map(value => value: java.lang.String))(
        _.distributionName
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest
      .wrap(buildAwsValue())
}
object GetDistributionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest(
        distributionNameValue.map(value => value),
        pageTokenValue.map(value => value)
      )
    def distributionNameValue: Option[ResourceName]
    def pageTokenValue: Option[String]
    def distributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionNameValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest.ReadOnly {
    override def distributionNameValue: Option[ResourceName] =
      scala.Option(impl.distributionName()).map(value => value: ResourceName)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionsRequest.ReadOnly =
    new Wrapper(impl)
}
