package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  MetricPeriod,
  Timestamp,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDistributionMetricDataRequest(
    distributionName: ResourceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.DistributionMetricName,
    startTime: Timestamp,
    endTime: Timestamp,
    period: MetricPeriod,
    unit: io.github.vigoo.zioaws.lightsail.model.MetricUnit,
    statistics: Iterable[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest = {
    import GetDistributionMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
      .builder()
      .distributionName(distributionName: java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .period(period: Integer)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest
      .wrap(buildAwsValue())
}
object GetDistributionMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest(
        distributionNameValue,
        metricNameValue,
        startTimeValue,
        endTimeValue,
        periodValue,
        unitValue,
        statisticsValue
      )
    def distributionNameValue: ResourceName
    def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.DistributionMetricName
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def periodValue: MetricPeriod
    def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def distributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.DistributionMetricName
    ] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def unit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricUnit] =
      ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly {
    override def distributionNameValue: ResourceName =
      impl.distributionName(): ResourceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.DistributionMetricName =
      io.github.vigoo.zioaws.lightsail.model.DistributionMetricName
        .wrap(impl.metricName())
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit =
      io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(impl.unit())
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
