package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskSnapshotsResponse(
    diskSnapshots: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse = {
    import GetDiskSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
      .builder()
      .optionallyWith(
        diskSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.diskSnapshots)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse
      .wrap(buildAwsValue())
}
object GetDiskSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse(
        diskSnapshotsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def diskSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def diskSnapshots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("diskSnapshots", diskSnapshotsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly {
    override def diskSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly]
    ] = scala
      .Option(impl.diskSnapshots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
