package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetContainerServiceDeploymentsRequest(
    serviceName: ContainerServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest = {
    import GetContainerServiceDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsRequest
      .wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerServiceDeploymentsRequest(serviceNameValue)
    def serviceNameValue: ContainerServiceName
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsRequest.ReadOnly =
    new Wrapper(impl)
}
