package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerLogResponse(
    logEvents: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse = {
    import GetContainerLogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
      .builder()
      .optionallyWith(
        logEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logEvents)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse
      .wrap(buildAwsValue())
}
object GetContainerLogResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse =
      io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse(
        logEventsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def logEventsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def logEvents: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("logEvents", logEventsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly {
    override def logEventsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent.ReadOnly
    ]] = scala
      .Option(impl.logEvents())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContainerServiceLogEvent
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerLogResponse.ReadOnly =
    new Wrapper(impl)
}
