package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerApiMetadataResponse(
    metadata: Option[Iterable[Map[String, String]]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse = {
    import GetContainerApiMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
      .builder()
      .optionallyWith(
        metadata.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse
      .wrap(buildAwsValue())
}
object GetContainerApiMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerApiMetadataResponse(metadataValue.map(value => value))
    def metadataValue: Option[List[Map[String, String]]]
    def metadata: ZIO[Any, AwsError, List[Map[String, String]]] =
      AwsError.unwrapOptionField("metadata", metadataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly {
    override def metadataValue: Option[List[Map[String, String]]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerApiMetadataResponse.ReadOnly =
    new Wrapper(impl)
}
