package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContactMethodsResponse(
    contactMethods: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContactMethod]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse = {
    import GetContactMethodsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
      .builder()
      .optionallyWith(
        contactMethods.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contactMethods)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse
      .wrap(buildAwsValue())
}
object GetContactMethodsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse(
        contactMethodsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def contactMethodsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly]
    ]
    def contactMethods: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly
    ]] = AwsError.unwrapOptionField("contactMethods", contactMethodsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly {
    override def contactMethodsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly]
    ] = scala
      .Option(impl.contactMethods())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContactMethod.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContactMethodsResponse.ReadOnly =
    new Wrapper(impl)
}
