package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContactMethodsRequest(
    protocols: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest = {
    import GetContactMethodsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
      .builder()
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContactMethodsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContactMethodsRequest
      .wrap(buildAwsValue())
}
object GetContactMethodsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContactMethodsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetContactMethodsRequest(protocolsValue.map(value => value))
    def protocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]]
    def protocols: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ]] = AwsError.unwrapOptionField("protocols", protocolsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContactMethodsRequest.ReadOnly {
    override def protocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]] =
      scala
        .Option(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.ContactProtocol.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContactMethodsRequest.ReadOnly =
    new Wrapper(impl)
}
