package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCloudFormationStackRecordsResponse(
    cloudFormationStackRecords: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse = {
    import GetCloudFormationStackRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
      .builder()
      .optionallyWith(
        cloudFormationStackRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudFormationStackRecords)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse
      .wrap(buildAwsValue())
}
object GetCloudFormationStackRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetCloudFormationStackRecordsResponse(
          cloudFormationStackRecordsValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def cloudFormationStackRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def cloudFormationStackRecords: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudFormationStackRecords",
      cloudFormationStackRecordsValue
    )
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly {
    override def cloudFormationStackRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord.ReadOnly
    ]] = scala
      .Option(impl.cloudFormationStackRecords())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CloudFormationStackRecord
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetCloudFormationStackRecordsResponse.ReadOnly =
    new Wrapper(impl)
}
