package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  CertificateName,
  IncludeCertificateDetails
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCertificatesRequest(
    certificateStatuses: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CertificateStatus]
    ] = None,
    includeCertificateDetails: Option[IncludeCertificateDetails] = None,
    certificateName: Option[CertificateName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest = {
    import GetCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
      .builder()
      .optionallyWith(
        certificateStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.certificateStatusesWithStrings)
      .optionallyWith(
        includeCertificateDetails.map(value => value: java.lang.Boolean)
      )(_.includeCertificateDetails)
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest
      .wrap(buildAwsValue())
}
object GetCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest =
      io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest(
        certificateStatusesValue.map(value => value),
        includeCertificateDetailsValue.map(value => value),
        certificateNameValue.map(value => value)
      )
    def certificateStatusesValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.CertificateStatus]]
    def includeCertificateDetailsValue: Option[IncludeCertificateDetails]
    def certificateNameValue: Option[CertificateName]
    def certificateStatuses: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CertificateStatus
    ]] = AwsError.unwrapOptionField(
      "certificateStatuses",
      certificateStatusesValue
    )
    def includeCertificateDetails
        : ZIO[Any, AwsError, IncludeCertificateDetails] =
      AwsError.unwrapOptionField(
        "includeCertificateDetails",
        includeCertificateDetailsValue
      )
    def certificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest.ReadOnly {
    override def certificateStatusesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CertificateStatus]
    ] = scala
      .Option(impl.certificateStatuses())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CertificateStatus.wrap(item)
        }.toList
      )
    override def includeCertificateDetailsValue
        : Option[IncludeCertificateDetails] = scala
      .Option(impl.includeCertificateDetails())
      .map(value => value: IncludeCertificateDetails)
    override def certificateNameValue: Option[CertificateName] =
      scala.Option(impl.certificateName()).map(value => value: CertificateName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
