package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBundlesRequest(
    includeInactive: Option[Boolean] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBundlesRequest = {
    import GetBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest
      .wrap(buildAwsValue())
}
object GetBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest =
      io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest(
        includeInactiveValue.map(value => value),
        pageTokenValue.map(value => value)
      )
    def includeInactiveValue: Option[Boolean]
    def pageTokenValue: Option[String]
    def includeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactiveValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest.ReadOnly {
    override def includeInactiveValue: Option[Boolean] =
      scala.Option(impl.includeInactive()).map(value => value: Boolean)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBundlesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetBundlesRequest.ReadOnly =
    new Wrapper(impl)
}
