package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.BucketName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketsRequest(
    bucketName: Option[BucketName] = None,
    pageToken: Option[String] = None,
    includeConnectedResources: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketsRequest = {
    import GetBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
      .builder()
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        includeConnectedResources.map(value => value: java.lang.Boolean)
      )(_.includeConnectedResources)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest
      .wrap(buildAwsValue())
}
object GetBucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest(
        bucketNameValue.map(value => value),
        pageTokenValue.map(value => value),
        includeConnectedResourcesValue.map(value => value)
      )
    def bucketNameValue: Option[BucketName]
    def pageTokenValue: Option[String]
    def includeConnectedResourcesValue: Option[Boolean]
    def bucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketNameValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
    def includeConnectedResources: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "includeConnectedResources",
        includeConnectedResourcesValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest.ReadOnly {
    override def bucketNameValue: Option[BucketName] =
      scala.Option(impl.bucketName()).map(value => value: BucketName)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
    override def includeConnectedResourcesValue: Option[Boolean] = scala
      .Option(impl.includeConnectedResources())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketsRequest.ReadOnly =
    new Wrapper(impl)
}
