package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  MetricPeriod,
  IsoDate,
  BucketName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetBucketMetricDataRequest(
    bucketName: BucketName,
    metricName: io.github.vigoo.zioaws.lightsail.model.BucketMetricName,
    startTime: IsoDate,
    endTime: IsoDate,
    period: MetricPeriod,
    statistics: Iterable[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ],
    unit: io.github.vigoo.zioaws.lightsail.model.MetricUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest = {
    import GetBucketMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .period(period: Integer)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .unit(unit.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest
      .wrap(buildAwsValue())
}
object GetBucketMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest(
        bucketNameValue,
        metricNameValue,
        startTimeValue,
        endTimeValue,
        periodValue,
        statisticsValue,
        unitValue
      )
    def bucketNameValue: BucketName
    def metricNameValue: io.github.vigoo.zioaws.lightsail.model.BucketMetricName
    def startTimeValue: IsoDate
    def endTimeValue: IsoDate
    def periodValue: MetricPeriod
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.BucketMetricName
    ] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
    def unit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricUnit] =
      ZIO.succeed(unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.BucketMetricName =
      io.github.vigoo.zioaws.lightsail.model.BucketMetricName
        .wrap(impl.metricName())
    override def startTimeValue: IsoDate = impl.startTime(): IsoDate
    override def endTimeValue: IsoDate = impl.endTime(): IsoDate
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
    override def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit =
      io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(impl.unit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
