package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketBundlesResponse(
    bundles: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.BucketBundle]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse = {
    import GetBucketBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse
      .wrap(buildAwsValue())
}
object GetBucketBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse(
        bundlesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def bundlesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly]
    ]
    def bundles: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundlesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly {
    override def bundlesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly]
    ] = scala
      .Option(impl.bundles())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.BucketBundle.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
