package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketBundlesRequest(
    includeInactive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest = {
    import GetBucketBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesRequest
      .wrap(buildAwsValue())
}
object GetBucketBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetBucketBundlesRequest(includeInactiveValue.map(value => value))
    def includeInactiveValue: Option[Boolean]
    def includeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesRequest.ReadOnly {
    override def includeInactiveValue: Option[Boolean] =
      scala.Option(impl.includeInactive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketBundlesRequest.ReadOnly =
    new Wrapper(impl)
}
