package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBlueprintsResponse(
    blueprints: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Blueprint]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse = {
    import GetBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse
      .wrap(buildAwsValue())
}
object GetBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse(
        blueprintsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def blueprintsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def blueprints: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly
    ]] = AwsError.unwrapOptionField("blueprints", blueprintsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse.ReadOnly {
    override def blueprintsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Blueprint.ReadOnly]
    ] = scala
      .Option(impl.blueprints())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Blueprint.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetBlueprintsResponse.ReadOnly =
    new Wrapper(impl)
}
