package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAutoSnapshotsResponse(
    resourceName: Option[ResourceName] = None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    autoSnapshots: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse = {
    import GetAutoSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
      .builder()
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        autoSnapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoSnapshots)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse
      .wrap(buildAwsValue())
}
object GetAutoSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse(
        resourceNameValue.map(value => value),
        resourceTypeValue.map(value => value),
        autoSnapshotsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def resourceNameValue: Option[ResourceName]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def autoSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly]
    ]
    def resourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceNameValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def autoSnapshots: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("autoSnapshots", autoSnapshotsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly {
    override def resourceNameValue: Option[ResourceName] =
      scala.Option(impl.resourceName()).map(value => value: ResourceName)
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def autoSnapshotsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly]
    ] = scala
      .Option(impl.autoSnapshots())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetAutoSnapshotsResponse.ReadOnly =
    new Wrapper(impl)
}
