package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportSnapshotRequest(sourceSnapshotName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest = {
    import ExportSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
      .builder()
      .sourceSnapshotName(sourceSnapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRequest
      .wrap(buildAwsValue())
}
object ExportSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .ExportSnapshotRequest(sourceSnapshotNameValue)
    def sourceSnapshotNameValue: ResourceName
    def sourceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(sourceSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRequest.ReadOnly {
    override def sourceSnapshotNameValue: ResourceName =
      impl.sourceSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
