package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExportSnapshotRecord(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.RecordState] = None,
    sourceInfo: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo
    ] = None,
    destinationInfo: Option[
      io.github.vigoo.zioaws.lightsail.model.DestinationInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord = {
    import ExportSnapshotRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(sourceInfo.map(value => value.buildAwsValue()))(
        _.sourceInfo
      )
      .optionallyWith(destinationInfo.map(value => value.buildAwsValue()))(
        _.destinationInfo
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord
      .wrap(buildAwsValue())
}
object ExportSnapshotRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord =
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord(
        nameValue.map(value => value),
        arnValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        stateValue.map(value => value),
        sourceInfoValue.map(value => value.editable),
        destinationInfoValue.map(value => value.editable)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def stateValue: Option[io.github.vigoo.zioaws.lightsail.model.RecordState]
    def sourceInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly
    ]
    def destinationInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly
    ]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RecordState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def sourceInfo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly
    ] = AwsError.unwrapOptionField("sourceInfo", sourceInfoValue)
    def destinationInfo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("destinationInfo", destinationInfoValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord
  ) extends io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RecordState] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RecordState.wrap(value)
      )
    override def sourceInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly
    ] = scala
      .Option(impl.sourceInfo())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo
          .wrap(value)
      )
    override def destinationInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly
    ] = scala
      .Option(impl.destinationInfo())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.DestinationInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecord
  ): io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecord.ReadOnly =
    new Wrapper(impl)
}
