package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnableAddOnRequest(
    resourceName: ResourceName,
    addOnRequest: io.github.vigoo.zioaws.lightsail.model.AddOnRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest = {
    import EnableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .addOnRequest(addOnRequest.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.EnableAddOnRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.EnableAddOnRequest
      .wrap(buildAwsValue())
}
object EnableAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.EnableAddOnRequest =
      io.github.vigoo.zioaws.lightsail.model
        .EnableAddOnRequest(resourceNameValue, addOnRequestValue.editable)
    def resourceNameValue: ResourceName
    def addOnRequestValue
        : io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def addOnRequest: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    ] = ZIO.succeed(addOnRequestValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.EnableAddOnRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def addOnRequestValue
        : io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest
        .wrap(impl.addOnRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest
  ): io.github.vigoo.zioaws.lightsail.model.EnableAddOnRequest.ReadOnly =
    new Wrapper(impl)
}
