package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Base64
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DownloadDefaultKeyPairResponse(
    publicKeyBase64: Option[Base64] = None,
    privateKeyBase64: Option[Base64] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse = {
    import DownloadDefaultKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
      .builder()
      .optionallyWith(publicKeyBase64.map(value => value: java.lang.String))(
        _.publicKeyBase64
      )
      .optionallyWith(privateKeyBase64.map(value => value: java.lang.String))(
        _.privateKeyBase64
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse
      .wrap(buildAwsValue())
}
object DownloadDefaultKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse =
      io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse(
        publicKeyBase64Value.map(value => value),
        privateKeyBase64Value.map(value => value)
      )
    def publicKeyBase64Value: Option[Base64]
    def privateKeyBase64Value: Option[Base64]
    def publicKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64Value)
    def privateKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly {
    override def publicKeyBase64Value: Option[Base64] =
      scala.Option(impl.publicKeyBase64()).map(value => value: Base64)
    override def privateKeyBase64Value: Option[Base64] =
      scala.Option(impl.privateKeyBase64()).map(value => value: Base64)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse
  ): io.github.vigoo.zioaws.lightsail.model.DownloadDefaultKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
