package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskInfo(
    name: Option[String] = None,
    path: Option[NonEmptyString] = None,
    sizeInGb: Option[Integer] = None,
    isSystemDisk: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskInfo = {
    import DiskInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DiskInfo.wrap(buildAwsValue())
}
object DiskInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DiskInfo =
      io.github.vigoo.zioaws.lightsail.model.DiskInfo(
        nameValue.map(value => value),
        pathValue.map(value => value),
        sizeInGbValue.map(value => value),
        isSystemDiskValue.map(value => value)
      )
    def nameValue: Option[String]
    def pathValue: Option[NonEmptyString]
    def sizeInGbValue: Option[Integer]
    def isSystemDiskValue: Option[Boolean]
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def path: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", pathValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def isSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDiskValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly {
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def pathValue: Option[NonEmptyString] =
      scala.Option(impl.path()).map(value => value: NonEmptyString)
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override def isSystemDiskValue: Option[Boolean] =
      scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskInfo
  ): io.github.vigoo.zioaws.lightsail.model.DiskInfo.ReadOnly = new Wrapper(
    impl
  )
}
