package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRelationalDatabaseSnapshotRequest(
    relationalDatabaseSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest = {
    import DeleteRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseSnapshotName(
        relationalDatabaseSnapshotName: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteRelationalDatabaseSnapshotRequest(
          relationalDatabaseSnapshotNameValue
        )
    def relationalDatabaseSnapshotNameValue: ResourceName
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly {
    override def relationalDatabaseSnapshotNameValue: ResourceName =
      impl.relationalDatabaseSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
