package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLoadBalancerRequest(loadBalancerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest = {
    import DeleteLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteLoadBalancerRequest(loadBalancerNameValue)
    def loadBalancerNameValue: ResourceName
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
