package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDistributionRequest(
    distributionName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest = {
    import DeleteDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
      .builder()
      .optionallyWith(distributionName.map(value => value: java.lang.String))(
        _.distributionName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteDistributionRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteDistributionRequest
      .wrap(buildAwsValue())
}
object DeleteDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteDistributionRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteDistributionRequest(distributionNameValue.map(value => value))
    def distributionNameValue: Option[ResourceName]
    def distributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteDistributionRequest.ReadOnly {
    override def distributionNameValue: Option[ResourceName] =
      scala.Option(impl.distributionName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
