package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDiskSnapshotRequest(diskSnapshotName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest = {
    import DeleteDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
      .builder()
      .diskSnapshotName(diskSnapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteDiskSnapshotRequest(diskSnapshotNameValue)
    def diskSnapshotNameValue: ResourceName
    def diskSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(diskSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly {
    override def diskSnapshotNameValue: ResourceName =
      impl.diskSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteDiskSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
