package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContainerServiceRequest(
    serviceName: ContainerServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest = {
    import DeleteContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceRequest
      .wrap(buildAwsValue())
}
object DeleteContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteContainerServiceRequest(serviceNameValue)
    def serviceNameValue: ContainerServiceName
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
