package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContactMethodRequest(
    protocol: io.github.vigoo.zioaws.lightsail.model.ContactProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest = {
    import DeleteContactMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
      .builder()
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodRequest
      .wrap(buildAwsValue())
}
object DeleteContactMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteContactMethodRequest(protocolValue)
    def protocolValue: io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    def protocol: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ] = ZIO.succeed(protocolValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodRequest.ReadOnly {
    override def protocolValue
        : io.github.vigoo.zioaws.lightsail.model.ContactProtocol =
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
        .wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteContactMethodRequest.ReadOnly =
    new Wrapper(impl)
}
