package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.BucketName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteBucketRequest(
    bucketName: BucketName,
    forceDelete: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest = {
    import DeleteBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest
      .wrap(buildAwsValue())
}
object DeleteBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest =
      io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest(
        bucketNameValue,
        forceDeleteValue.map(value => value)
      )
    def bucketNameValue: BucketName
    def forceDeleteValue: Option[Boolean]
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def forceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDeleteValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def forceDeleteValue: Option[Boolean] =
      scala.Option(impl.forceDelete()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteBucketRequest.ReadOnly =
    new Wrapper(impl)
}
