package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRelationalDatabaseSnapshotRequest(
    relationalDatabaseName: ResourceName,
    relationalDatabaseSnapshotName: ResourceName,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest = {
    import CreateRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .relationalDatabaseSnapshotName(
        relationalDatabaseSnapshotName: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateRelationalDatabaseSnapshotRequest(
          relationalDatabaseNameValue,
          relationalDatabaseSnapshotNameValue,
          tagsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseSnapshotNameValue: ResourceName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def relationalDatabaseSnapshotNameValue: ResourceName =
      impl.relationalDatabaseSnapshotName(): ResourceName
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
