package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateKeyPairRequest(
    keyPairName: ResourceName,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest = {
    import CreateKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
      .builder()
      .keyPairName(keyPairName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest
      .wrap(buildAwsValue())
}
object CreateKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest(
        keyPairNameValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def keyPairNameValue: ResourceName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def keyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest.ReadOnly {
    override def keyPairNameValue: ResourceName =
      impl.keyPairName(): ResourceName
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateKeyPairRequest.ReadOnly =
    new Wrapper(impl)
}
