package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateInstancesFromSnapshotRequest(
    instanceNames: Iterable[String],
    attachedDiskMapping: Option[Map[ResourceName, Iterable[
      io.github.vigoo.zioaws.lightsail.model.DiskMap
    ]]] = None,
    availabilityZone: String,
    instanceSnapshotName: Option[ResourceName] = None,
    bundleId: NonEmptyString,
    userData: Option[String] = None,
    keyPairName: Option[ResourceName] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    addOns: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AddOnRequest]
    ] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None,
    sourceInstanceName: Option[String] = None,
    restoreDate: Option[String] = None,
    useLatestRestorableAutoSnapshot: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest = {
    import CreateInstancesFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
      .builder()
      .instanceNames(instanceNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        attachedDiskMapping.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.attachedDiskMapping)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(
        instanceSnapshotName.map(value => value: java.lang.String)
      )(_.instanceSnapshotName)
      .bundleId(bundleId: java.lang.String)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(keyPairName.map(value => value: java.lang.String))(
        _.keyPairName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(sourceInstanceName.map(value => value: java.lang.String))(
        _.sourceInstanceName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateInstancesFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest(
        instanceNamesValue,
        attachedDiskMappingValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.editable
            }
          })
        ),
        availabilityZoneValue,
        instanceSnapshotNameValue.map(value => value),
        bundleIdValue,
        userDataValue.map(value => value),
        keyPairNameValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ipAddressTypeValue.map(value => value),
        sourceInstanceNameValue.map(value => value),
        restoreDateValue.map(value => value),
        useLatestRestorableAutoSnapshotValue.map(value => value)
      )
    def instanceNamesValue: List[String]
    def attachedDiskMappingValue: Option[Map[ResourceName, List[
      io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly
    ]]]
    def availabilityZoneValue: String
    def instanceSnapshotNameValue: Option[ResourceName]
    def bundleIdValue: NonEmptyString
    def userDataValue: Option[String]
    def keyPairNameValue: Option[ResourceName]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def sourceInstanceNameValue: Option[String]
    def restoreDateValue: Option[String]
    def useLatestRestorableAutoSnapshotValue: Option[Boolean]
    def instanceNames: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(instanceNamesValue)
    def attachedDiskMapping: ZIO[Any, AwsError, Map[ResourceName, List[
      io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly
    ]]] = AwsError.unwrapOptionField(
      "attachedDiskMapping",
      attachedDiskMappingValue
    )
    def availabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZoneValue)
    def instanceSnapshotName: ZIO[Any, AwsError, ResourceName] = AwsError
      .unwrapOptionField("instanceSnapshotName", instanceSnapshotNameValue)
    def bundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleIdValue)
    def userData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userDataValue)
    def keyPairName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def sourceInstanceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceInstanceName", sourceInstanceNameValue)
    def restoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshotValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly {
    override def instanceNamesValue: List[String] = impl
      .instanceNames()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override def attachedDiskMappingValue: Option[Map[ResourceName, List[
      io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly
    ]]] = scala
      .Option(impl.attachedDiskMapping())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: ResourceName) -> value.asScala.map { item =>
              io.github.vigoo.zioaws.lightsail.model.DiskMap.wrap(item)
            }.toList
          })
          .toMap
      )
    override def availabilityZoneValue: String = impl.availabilityZone(): String
    override def instanceSnapshotNameValue: Option[ResourceName] = scala
      .Option(impl.instanceSnapshotName())
      .map(value => value: ResourceName)
    override def bundleIdValue: NonEmptyString = impl.bundleId(): NonEmptyString
    override def userDataValue: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override def keyPairNameValue: Option[ResourceName] =
      scala.Option(impl.keyPairName()).map(value => value: ResourceName)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
    override def sourceInstanceNameValue: Option[String] =
      scala.Option(impl.sourceInstanceName()).map(value => value: String)
    override def restoreDateValue: Option[String] =
      scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: Option[Boolean] = scala
      .Option(impl.useLatestRestorableAutoSnapshot())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateInstancesFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
