package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDomainRequest(
    domainName: DomainName,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest
      .wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest(
        domainNameValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def domainNameValue: DomainName
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDomainRequest.ReadOnly =
    new Wrapper(impl)
}
