package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDistributionResponse(
    distribution: Option[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution
    ] = None,
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse
      .wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse(
        distributionValue.map(value => value.editable),
        operationValue.map(value => value.editable)
      )
    def distributionValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ]
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def distribution: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ] = AwsError.unwrapOptionField("distribution", distributionValue)
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly {
    override def distributionValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ] = scala
      .Option(impl.distribution())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.wrap(value)
      )
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
