package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDistributionRequest(
    distributionName: ResourceName,
    origin: io.github.vigoo.zioaws.lightsail.model.InputOrigin,
    defaultCacheBehavior: io.github.vigoo.zioaws.lightsail.model.CacheBehavior,
    cacheBehaviorSettings: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings
    ] = None,
    cacheBehaviors: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath]
    ] = None,
    bundleId: String,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest = {
    import CreateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
      .builder()
      .distributionName(distributionName: java.lang.String)
      .origin(origin.buildAwsValue())
      .defaultCacheBehavior(defaultCacheBehavior.buildAwsValue())
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .bundleId(bundleId: java.lang.String)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest
      .wrap(buildAwsValue())
}
object CreateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest(
        distributionNameValue,
        originValue.editable,
        defaultCacheBehaviorValue.editable,
        cacheBehaviorSettingsValue.map(value => value.editable),
        cacheBehaviorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        bundleIdValue,
        ipAddressTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def distributionNameValue: ResourceName
    def originValue: io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly
    def defaultCacheBehaviorValue
        : io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    def cacheBehaviorSettingsValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ]
    def bundleIdValue: String
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def distributionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(distributionNameValue)
    def origin: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly
    ] = ZIO.succeed(originValue)
    def defaultCacheBehavior: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly
    ] = ZIO.succeed(defaultCacheBehaviorValue)
    def cacheBehaviorSettings: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cacheBehaviorSettings",
      cacheBehaviorSettingsValue
    )
    def cacheBehaviors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def bundleId: ZIO[Any, Nothing, String] = ZIO.succeed(bundleIdValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest.ReadOnly {
    override def distributionNameValue: ResourceName =
      impl.distributionName(): ResourceName
    override def originValue
        : io.github.vigoo.zioaws.lightsail.model.InputOrigin.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.InputOrigin.wrap(impl.origin())
    override def defaultCacheBehaviorValue
        : io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.CacheBehavior
        .wrap(impl.defaultCacheBehavior())
    override def cacheBehaviorSettingsValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CacheSettings.ReadOnly
    ] = scala
      .Option(impl.cacheBehaviorSettings())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CacheSettings.wrap(value)
      )
    override def cacheBehaviorsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.ReadOnly]
    ] = scala
      .Option(impl.cacheBehaviors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CacheBehaviorPerPath.wrap(item)
        }.toList
      )
    override def bundleIdValue: String = impl.bundleId(): String
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
