package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDiskRequest(
    diskName: ResourceName,
    availabilityZone: NonEmptyString,
    sizeInGb: Integer,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    addOns: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AddOnRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskRequest = {
    import CreateDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .availabilityZone(availabilityZone: java.lang.String)
      .sizeInGb(sizeInGb: java.lang.Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest
      .wrap(buildAwsValue())
}
object CreateDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest(
        diskNameValue,
        availabilityZoneValue,
        sizeInGbValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def diskNameValue: ResourceName
    def availabilityZoneValue: NonEmptyString
    def sizeInGbValue: Integer
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ]
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
    def availabilityZone: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(availabilityZoneValue)
    def sizeInGb: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGbValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
    override def availabilityZoneValue: NonEmptyString =
      impl.availabilityZone(): NonEmptyString
    override def sizeInGbValue: Integer = impl.sizeInGb(): Integer
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDiskRequest.ReadOnly =
    new Wrapper(impl)
}
