package io.github.vigoo.zioaws.lightsail.model
import java.lang.Integer
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ContainerServiceScale,
  ContainerServiceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceRequest(
    serviceName: ContainerServiceName,
    power: io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName,
    scale: ContainerServiceScale,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None,
    deployment: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest = {
    import CreateContainerServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .power(power.unwrap)
      .scale(scale: Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .optionallyWith(deployment.map(value => value.buildAwsValue()))(
        _.deployment
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest
      .wrap(buildAwsValue())
}
object CreateContainerServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest(
        serviceNameValue,
        powerValue,
        scaleValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        publicDomainNamesValue.map(value => value),
        deploymentValue.map(value => value.editable)
      )
    def serviceNameValue: ContainerServiceName
    def powerValue
        : io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    def scaleValue: ContainerServiceScale
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def publicDomainNamesValue: Option[Map[String, List[String]]]
    def deploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ]
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def power: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = ZIO.succeed(powerValue)
    def scale: ZIO[Any, Nothing, ContainerServiceScale] =
      ZIO.succeed(scaleValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def publicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
    def deployment: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ] = AwsError.unwrapOptionField("deployment", deploymentValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def powerValue
        : io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName =
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
        .wrap(impl.power())
    override def scaleValue: ContainerServiceScale =
      impl.scale(): ContainerServiceScale
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def publicDomainNamesValue: Option[Map[String, List[String]]] =
      scala
        .Option(impl.publicDomainNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override def deploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentRequest.ReadOnly
    ] = scala
      .Option(impl.deployment())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeploymentRequest
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRequest.ReadOnly =
    new Wrapper(impl)
}
