package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceRegistryLoginResponse(
    registryLogin: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse = {
    import CreateContainerServiceRegistryLoginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
      .builder()
      .optionallyWith(registryLogin.map(value => value.buildAwsValue()))(
        _.registryLogin
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse
      .wrap(buildAwsValue())
}
object CreateContainerServiceRegistryLoginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse =
      io.github.vigoo.zioaws.lightsail.model
        .CreateContainerServiceRegistryLoginResponse(
          registryLoginValue.map(value => value.editable)
        )
    def registryLoginValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ]
    def registryLogin: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ] = AwsError.unwrapOptionField("registryLogin", registryLoginValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly {
    override def registryLoginValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin.ReadOnly
    ] = scala
      .Option(impl.registryLogin())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceRegistryLogin
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceRegistryLoginResponse.ReadOnly =
    new Wrapper(impl)
}
