package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateCloudFormationStackRequest(
    instances: Iterable[io.github.vigoo.zioaws.lightsail.model.InstanceEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest = {
    import CreateCloudFormationStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
      .builder()
      .instances(instances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackRequest
      .wrap(buildAwsValue())
}
object CreateCloudFormationStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateCloudFormationStackRequest(instancesValue.map { item =>
          item.editable
        })
    def instancesValue
        : List[io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly]
    def instances: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly
    ]] = ZIO.succeed(instancesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly {
    override def instancesValue
        : List[io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly] =
      impl
        .instances()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstanceEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateCloudFormationStackRequest.ReadOnly =
    new Wrapper(impl)
}
