package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCertificateResponse(
    certificate: Option[
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary
    ] = None,
    operations: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Operation]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse = {
    import CreateCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse
      .wrap(buildAwsValue())
}
object CreateCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse(
        certificateValue.map(value => value.editable),
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def certificateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly
    ]
    def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ]
    def certificate: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificateValue)
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly {
    override def certificateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly
    ] = scala
      .Option(impl.certificate())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.CertificateSummary.wrap(value)
      )
    override def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
