package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  CertificateName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCertificateRequest(
    certificateName: CertificateName,
    domainName: DomainName,
    subjectAlternativeNames: Option[Iterable[DomainName]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest = {
    import CreateCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
      .builder()
      .certificateName(certificateName: java.lang.String)
      .domainName(domainName: java.lang.String)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest
      .wrap(buildAwsValue())
}
object CreateCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest(
        certificateNameValue,
        domainNameValue,
        subjectAlternativeNamesValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def certificateNameValue: CertificateName
    def domainNameValue: DomainName
    def subjectAlternativeNamesValue: Option[List[DomainName]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def certificateName: ZIO[Any, Nothing, CertificateName] =
      ZIO.succeed(certificateNameValue)
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
    def subjectAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNamesValue
      )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest.ReadOnly {
    override def certificateNameValue: CertificateName =
      impl.certificateName(): CertificateName
    override def domainNameValue: DomainName = impl.domainName(): DomainName
    override def subjectAlternativeNamesValue: Option[List[DomainName]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          item: DomainName
        }.toList
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
