package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CookieObject(
    option: Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues] = None,
    cookiesAllowList: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CookieObject = {
    import CookieObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CookieObject
      .builder()
      .optionallyWith(option.map(value => value.unwrap))(_.option)
      .optionallyWith(
        cookiesAllowList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cookiesAllowList)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CookieObject.wrap(buildAwsValue())
}
object CookieObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CookieObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CookieObject =
      io.github.vigoo.zioaws.lightsail.model.CookieObject(
        optionValue.map(value => value),
        cookiesAllowListValue.map(value => value)
      )
    def optionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues]
    def cookiesAllowListValue: Option[List[String]]
    def option: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ForwardValues
    ] = AwsError.unwrapOptionField("option", optionValue)
    def cookiesAllowList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cookiesAllowList", cookiesAllowListValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CookieObject
  ) extends io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly {
    override def optionValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ForwardValues] = scala
      .Option(impl.option())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ForwardValues.wrap(value)
      )
    override def cookiesAllowListValue: Option[List[String]] = scala
      .Option(impl.cookiesAllowList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CookieObject
  ): io.github.vigoo.zioaws.lightsail.model.CookieObject.ReadOnly = new Wrapper(
    impl
  )
}
