package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceStateDetail(
    code: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetailCode
    ] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail = {
    import ContainerServiceStateDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail
      .wrap(buildAwsValue())
}
object ContainerServiceStateDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail(
        codeValue.map(value => value),
        messageValue.map(value => value)
      )
    def codeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetailCode
    ]
    def messageValue: Option[String]
    def code: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetailCode
    ] = AwsError.unwrapOptionField("code", codeValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly {
    override def codeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetailCode
    ] = scala
      .Option(impl.code())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetailCode
          .wrap(value)
      )
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly =
    new Wrapper(impl)
}
