package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerImage(
    image: Option[String] = None,
    digest: Option[String] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerImage = {
    import ContainerImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerImage
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(digest.map(value => value: java.lang.String))(_.digest)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerImage.wrap(buildAwsValue())
}
object ContainerImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ContainerImage =
      io.github.vigoo.zioaws.lightsail.model.ContainerImage(
        imageValue.map(value => value),
        digestValue.map(value => value),
        createdAtValue.map(value => value)
      )
    def imageValue: Option[String]
    def digestValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def image: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", imageValue)
    def digest: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("digest", digestValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly {
    override def imageValue: Option[String] =
      scala.Option(impl.image()).map(value => value: String)
    override def digestValue: Option[String] =
      scala.Option(impl.digest()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerImage
  ): io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly =
    new Wrapper(impl)
}
