package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  SerialNumber,
  IssuerCA,
  IsoDate,
  EligibleToRenew,
  InUseResourceCount,
  DomainName,
  CertificateName,
  RevocationReason,
  KeyAlgorithm,
  RequestFailureReason,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Certificate(
    arn: Option[NonEmptyString] = None,
    name: Option[CertificateName] = None,
    domainName: Option[DomainName] = None,
    status: Option[io.github.vigoo.zioaws.lightsail.model.CertificateStatus] =
      None,
    serialNumber: Option[SerialNumber] = None,
    subjectAlternativeNames: Option[Iterable[DomainName]] = None,
    domainValidationRecords: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord]
    ] = None,
    requestFailureReason: Option[RequestFailureReason] = None,
    inUseResourceCount: Option[InUseResourceCount] = None,
    keyAlgorithm: Option[KeyAlgorithm] = None,
    createdAt: Option[IsoDate] = None,
    issuedAt: Option[IsoDate] = None,
    issuerCA: Option[IssuerCA] = None,
    notBefore: Option[IsoDate] = None,
    notAfter: Option[IsoDate] = None,
    eligibleToRenew: Option[EligibleToRenew] = None,
    renewalSummary: Option[
      io.github.vigoo.zioaws.lightsail.model.RenewalSummary
    ] = None,
    revokedAt: Option[IsoDate] = None,
    revocationReason: Option[RevocationReason] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    supportCode: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Certificate = {
    import Certificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Certificate
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(serialNumber.map(value => value: java.lang.String))(
        _.serialNumber
      )
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(
        requestFailureReason.map(value => value: java.lang.String)
      )(_.requestFailureReason)
      .optionallyWith(inUseResourceCount.map(value => value: Integer))(
        _.inUseResourceCount
      )
      .optionallyWith(keyAlgorithm.map(value => value: java.lang.String))(
        _.keyAlgorithm
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(issuedAt.map(value => value: Instant))(_.issuedAt)
      .optionallyWith(issuerCA.map(value => value: java.lang.String))(
        _.issuerCA
      )
      .optionallyWith(notBefore.map(value => value: Instant))(_.notBefore)
      .optionallyWith(notAfter.map(value => value: Instant))(_.notAfter)
      .optionallyWith(eligibleToRenew.map(value => value: java.lang.String))(
        _.eligibleToRenew
      )
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revokedAt.map(value => value: Instant))(_.revokedAt)
      .optionallyWith(revocationReason.map(value => value: java.lang.String))(
        _.revocationReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Certificate.wrap(buildAwsValue())
}
object Certificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Certificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Certificate =
      io.github.vigoo.zioaws.lightsail.model.Certificate(
        arnValue.map(value => value),
        nameValue.map(value => value),
        domainNameValue.map(value => value),
        statusValue.map(value => value),
        serialNumberValue.map(value => value),
        subjectAlternativeNamesValue.map(value => value),
        domainValidationRecordsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        requestFailureReasonValue.map(value => value),
        inUseResourceCountValue.map(value => value),
        keyAlgorithmValue.map(value => value),
        createdAtValue.map(value => value),
        issuedAtValue.map(value => value),
        issuerCAValue.map(value => value),
        notBeforeValue.map(value => value),
        notAfterValue.map(value => value),
        eligibleToRenewValue.map(value => value),
        renewalSummaryValue.map(value => value.editable),
        revokedAtValue.map(value => value),
        revocationReasonValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        supportCodeValue.map(value => value)
      )
    def arnValue: Option[NonEmptyString]
    def nameValue: Option[CertificateName]
    def domainNameValue: Option[DomainName]
    def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CertificateStatus]
    def serialNumberValue: Option[SerialNumber]
    def subjectAlternativeNamesValue: Option[List[DomainName]]
    def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]]
    def requestFailureReasonValue: Option[RequestFailureReason]
    def inUseResourceCountValue: Option[InUseResourceCount]
    def keyAlgorithmValue: Option[KeyAlgorithm]
    def createdAtValue: Option[IsoDate]
    def issuedAtValue: Option[IsoDate]
    def issuerCAValue: Option[IssuerCA]
    def notBeforeValue: Option[IsoDate]
    def notAfterValue: Option[IsoDate]
    def eligibleToRenewValue: Option[EligibleToRenew]
    def renewalSummaryValue
        : Option[io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly]
    def revokedAtValue: Option[IsoDate]
    def revocationReasonValue: Option[RevocationReason]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def supportCodeValue: Option[String]
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("name", nameValue)
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.CertificateStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def serialNumber: ZIO[Any, AwsError, SerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumberValue)
    def subjectAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNamesValue
      )
    def domainValidationRecords: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecordsValue
    )
    def requestFailureReason: ZIO[Any, AwsError, RequestFailureReason] =
      AwsError.unwrapOptionField(
        "requestFailureReason",
        requestFailureReasonValue
      )
    def inUseResourceCount: ZIO[Any, AwsError, InUseResourceCount] =
      AwsError.unwrapOptionField("inUseResourceCount", inUseResourceCountValue)
    def keyAlgorithm: ZIO[Any, AwsError, KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithmValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def issuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def issuerCA: ZIO[Any, AwsError, IssuerCA] =
      AwsError.unwrapOptionField("issuerCA", issuerCAValue)
    def notBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBeforeValue)
    def notAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfterValue)
    def eligibleToRenew: ZIO[Any, AwsError, EligibleToRenew] =
      AwsError.unwrapOptionField("eligibleToRenew", eligibleToRenewValue)
    def renewalSummary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummaryValue)
    def revokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAtValue)
    def revocationReason: ZIO[Any, AwsError, RevocationReason] =
      AwsError.unwrapOptionField("revocationReason", revocationReasonValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ) extends io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly {
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def nameValue: Option[CertificateName] =
      scala.Option(impl.name()).map(value => value: CertificateName)
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
    override def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.CertificateStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.CertificateStatus.wrap(value)
        )
    override def serialNumberValue: Option[SerialNumber] =
      scala.Option(impl.serialNumber()).map(value => value: SerialNumber)
    override def subjectAlternativeNamesValue: Option[List[DomainName]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          item: DomainName
        }.toList
      )
    override def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord.ReadOnly
    ]] = scala
      .Option(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.DomainValidationRecord
            .wrap(item)
        }.toList
      )
    override def requestFailureReasonValue: Option[RequestFailureReason] = scala
      .Option(impl.requestFailureReason())
      .map(value => value: RequestFailureReason)
    override def inUseResourceCountValue: Option[InUseResourceCount] = scala
      .Option(impl.inUseResourceCount())
      .map(value => value: InUseResourceCount)
    override def keyAlgorithmValue: Option[KeyAlgorithm] =
      scala.Option(impl.keyAlgorithm()).map(value => value: KeyAlgorithm)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def issuedAtValue: Option[IsoDate] =
      scala.Option(impl.issuedAt()).map(value => value: IsoDate)
    override def issuerCAValue: Option[IssuerCA] =
      scala.Option(impl.issuerCA()).map(value => value: IssuerCA)
    override def notBeforeValue: Option[IsoDate] =
      scala.Option(impl.notBefore()).map(value => value: IsoDate)
    override def notAfterValue: Option[IsoDate] =
      scala.Option(impl.notAfter()).map(value => value: IsoDate)
    override def eligibleToRenewValue: Option[EligibleToRenew] =
      scala.Option(impl.eligibleToRenew()).map(value => value: EligibleToRenew)
    override def renewalSummaryValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RenewalSummary.ReadOnly
    ] = scala
      .Option(impl.renewalSummary())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RenewalSummary.wrap(value)
      )
    override def revokedAtValue: Option[IsoDate] =
      scala.Option(impl.revokedAt()).map(value => value: IsoDate)
    override def revocationReasonValue: Option[RevocationReason] = scala
      .Option(impl.revocationReason())
      .map(value => value: RevocationReason)
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Certificate
  ): io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly = new Wrapper(
    impl
  )
}
