package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CacheBehavior(
    behavior: Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CacheBehavior = {
    import CacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehavior
      .builder()
      .optionallyWith(behavior.map(value => value.unwrap))(_.behavior)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CacheBehavior.wrap(buildAwsValue())
}
object CacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CacheBehavior =
      io.github.vigoo.zioaws.lightsail.model
        .CacheBehavior(behaviorValue.map(value => value))
    def behaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum]
    def behavior: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.BehaviorEnum
    ] = AwsError.unwrapOptionField("behavior", behaviorValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ) extends io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly {
    override def behaviorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.BehaviorEnum] = scala
      .Option(impl.behavior())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.BehaviorEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior
  ): io.github.vigoo.zioaws.lightsail.model.CacheBehavior.ReadOnly =
    new Wrapper(impl)
}
