package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  BucketAccessLogPrefix,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketAccessLogConfig(
    enabled: Boolean,
    destination: Option[BucketName] = None,
    prefix: Option[BucketAccessLogPrefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig = {
    import BucketAccessLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig
      .wrap(buildAwsValue())
}
object BucketAccessLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig =
      io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig(
        enabledValue,
        destinationValue.map(value => value),
        prefixValue.map(value => value)
      )
    def enabledValue: Boolean
    def destinationValue: Option[BucketName]
    def prefixValue: Option[BucketAccessLogPrefix]
    def enabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabledValue)
    def destination: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("destination", destinationValue)
    def prefix: ZIO[Any, AwsError, BucketAccessLogPrefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ) extends io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly {
    override def enabledValue: Boolean = impl.enabled(): Boolean
    override def destinationValue: Option[BucketName] =
      scala.Option(impl.destination()).map(value => value: BucketName)
    override def prefixValue: Option[BucketAccessLogPrefix] =
      scala.Option(impl.prefix()).map(value => value: BucketAccessLogPrefix)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketAccessLogConfig
  ): io.github.vigoo.zioaws.lightsail.model.BucketAccessLogConfig.ReadOnly =
    new Wrapper(impl)
}
